package org.nhindirect.gateway.smtp.james.mailet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.Locale;

import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.binary.Hex;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Patient;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.hl7.datatypes.PN;



public class StoreMail extends GenericMailet {

    private static final Log LOGGER = LogFactory.getFactory().getInstance(
            StoreMail.class);

    /**
	 * Parses incoming mail into its designated pieces and passes it onto SendMail to send or store the mail
	 * @param mail
	 * @throws MessagingException
	 */
    @Override
    public void service(Mail mail) throws MessagingException {

            MimeMessage message = null;
            String sender = null;
            ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
            long size = 0;
            Date date = null;
            long time = 0;
            String subject = null;
            String attachments = null;
            String body = null;
            String html = null;
            Enumeration headers = null;
            String message_id = null;
            JSONObject header = new JSONObject();
            String to = null;
            String cc = null;
            String bcc = null;
            int priority = 3;
            String mailtype = "html";
            byte[] sermessage = null;
            boolean request_dispatched = false;
            try {
                message = mail.getMessage();
                recipients.addAll( mail.getRecipients());
                sender = mail.getSender().toString();
                size = mail.getMessageSize();
                date = mail.getLastUpdated();
                if(date != null){
                    time = date.getTime()/ 1000L;
                }
                else{
                    time = new Date().getTime()/ 1000L;
                }
                subject = message.getSubject();
                message_id = message.getHeader("message-id", null);
                headers = message.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header head = (Header) headers.nextElement();
                    header.put(head.getName(), head.getValue());
                    if(head.getName().equalsIgnoreCase("to")){
                        to = head.getValue();
                    }
                    else if(head.getName().equalsIgnoreCase("cc")){
                        cc = head.getValue();
                    }
                    else if(head.getName().equalsIgnoreCase("bcc")){
                        bcc = head.getValue();
                    }
                    else if(head.getName().equalsIgnoreCase("X-Priority")){
                        priority = Integer.parseInt(head.getValue().replaceAll("[\\D]", ""));
                    }else if(head.getName().equalsIgnoreCase("original-id")){
                        message_id = head.getValue();
                    }else if(head.getName().equalsIgnoreCase("mdn-message")){
                        LOGGER.info("message is an mdn with disposition "+head.getValue());
                        return; //message is an mdn.  do not store
                    }
                    else if(head.getName().equalsIgnoreCase("Disposition-Notification-Options")){
                        request_dispatched = head.getValue().toUpperCase().contains("X-DIRECT-FINAL-DESTINATION-DELIVERY");
                    }
                }
                try {
                    body = parseBody(message.getContent(),
                            message.getContentType(), "text/plain", 0);
                } catch (IOException ex) {
                    LOGGER.debug("Messaging execption while retrieving body.");
                }
                try {
                    html = parseBody(message.getContent(),
                            message.getContentType(), "text/html", 0);
                } catch (IOException ex) {
                    LOGGER.debug("Messaging execption while retrieving html.");
                }
                try {
                     sermessage = serialize(message);
                } catch (IOException ex) {
                    LOGGER.debug("Failed to serizlize message");
                }
                if(html == null){
                    mailtype = "html";
                }
            } catch (MessagingException me) {
                LOGGER.debug("Messaging execption while retrieving message.");
            }
               
            SendMail.sendMessage(recipients, sender,
             attachments,  subject,  body,  html,
             time,   size,   header.toJSONString(),
            sermessage,  message_id,  to,  cc,  bcc,priority, mailtype,
            null, request_dispatched);

    }
    
        /*
	private String parseAttachments(MimeMessage message) {
                String attachmentTypesAsString = "";
		JSONArray attachmentTypes = new JSONArray();
                //int count = 1;
        try {
            // Get attachment extensions if message is not plaintext
            if (!message.getContentType().contains("text/plain")) {
                MimeMultipart attachments = new MimeMultipart();
                try {
                    attachments = (MimeMultipart) message.getContent();
                } catch (ClassCastException ce) {
                    attachments = null;
                } catch (IOException ie) {
                    LOGGER.debug("IO Error while post-processing incoming message.");
                } catch (MessagingException me) {
                    LOGGER.debug("Messaging Exception while post-processing incoming message.");
                }

                if (attachments != null) { // parse out attachments if they exist
                    for (int i = 0; i < attachments.getCount(); i++) {
                        BodyPart part = attachments.getBodyPart(i);
                        if (FilenameUtils.getExtension(part.getFileName()) != null) {
                            attachmentTypes.add(part.getFileName());
                        }
                    }
                }
            }
        } catch (MessagingException me) {
            LOGGER.debug("Messaging Exception while post-processing incoming message.");
        }
        if(attachmentTypes.isEmpty()){
            return null;
        }
        attachmentTypesAsString = attachmentTypes.toJSONString();
        return attachmentTypesAsString;
    }
        */
    private String parseBody(Object content, String type, String get, int depth)
            throws IOException {

        try {
            // Get attachment extensions if message is not plaintext
            if (!type.contains(get)) {
                MimeMultipart attachments;
                if (type.contains("multipart") && depth < 5) {// check if
                    // multipart and
                    // has not hit
                    // depth
                    try {
                        attachments = (MimeMultipart) content;
                    } catch (ClassCastException ce) {
                        return null;
                    }
                } else {
                    return null;
                }
                for (int i = 0; i < attachments.getCount(); i++) {
                    BodyPart part = attachments.getBodyPart(i);
                    String body = parseBody(part.getContent(),
                            part.getContentType(), get, depth + 1);
                    if (body != null) {
                        return body;
                    }
                }
                return null;

            } else {
                return content.toString();
            }
        } catch (MessagingException me) {
            LOGGER.debug("Messaging Exception while post-processing incoming message.");
        }
        return null;
    }


   
    public static byte[] serialize(MimeMessage message) throws IOException,
            MessagingException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        message.writeTo(b);
        return b.toByteArray();
    }

    
    /*
    private static HashMap<String,String> parseCCD(InputStream doc, String filename){
    	try{
            if(FilenameUtils.getExtension(filename).toLowerCase(Locale.getDefault()).equals("xml")) {
        	ClinicalDocument clinicalDocument = CDAUtil.load(doc);
        	HashMap<String,String> person = new HashMap<String,String>();
        	if(clinicalDocument.getPatients() != null && clinicalDocument.getPatients().size() > 0 ){
        		Patient patient = clinicalDocument.getPatients().get(0);
        		if(patient.getNames() != null && patient.getNames().size()> 0 && patient.getNames().get(0).hasContent()){
        			PN name = patient.getNames().get(0);
        			if(name.getGivens() != null && name.getGivens().size() > 0 && name.getGivens().get(0).hasContent()){
        				person.put("given_name", name.getGivens().get(0).getText());
        			}
        			if(name.getFamilies() != null && name.getFamilies().size() > 0 && name.getFamilies().get(0).hasContent()){
        				person.put("family_name", name.getFamilies().get(0).getText());
        			}
        		}
        		if(patient.getBirthTime() != null && patient.getBirthTime().hasContent()){
        			person.put("date_of_birth", patient.getBirthTime().getValue());
        		}	
        	}
        	if(clinicalDocument.getTitle() != null){
        		person.put("title", clinicalDocument.getTitle().getText());
        	}
        	if(clinicalDocument.getAuthors() != null && clinicalDocument.getAuthors().size() > 0 && clinicalDocument.getAuthors().get(0).getAssignedAuthor().getRepresentedOrganization() != null && clinicalDocument.getAuthors().get(0).getAssignedAuthor().getRepresentedOrganization().getNames().size() > 0){
        		person.put("organization", clinicalDocument.getAuthors().get(0).getAssignedAuthor().getRepresentedOrganization().getNames().get(0).getText());
        	}
                else if(clinicalDocument.getCustodian() != null && clinicalDocument.getCustodian().getAssignedCustodian() !=null && clinicalDocument.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization() !=null && clinicalDocument.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization().getName() !=null){
        		person.put("organization", clinicalDocument.getCustodian().getAssignedCustodian().getRepresentedCustodianOrganization().getName().getText());
        	}
                doc.reset();
                person.put("file_hash", hashFile(doc,filename));
        	return person;
            }
        }catch(ClassCastException e){
        	LOGGER.debug("Not a health document");
        }  catch (Exception e) {
		LOGGER.debug("Unkown error while parsing file");
	}
        return null;
    }
    */
    /*
    private static String hashFile(InputStream is, String filename){
    	try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] bytes = IOUtils.toByteArray(is);
                filename += new String(bytes);
                byte[] digest = sha1.digest(filename.getBytes());
                return new String(Hex.encodeHex(digest));
        } catch (IOException e) {
            LOGGER.debug("Failed to read file for hash");              
        } catch (NoSuchAlgorithmException ex) {
            LOGGER.debug("SHA one could not been used");
        }
        return null;
		
    }
  */
}


